function main() {
  attachLoginButton();
}
function attachLoginButton() {
  const selector = "#root .auth-container";
  const $container = document.querySelector(selector);
  if ($container) {
    didAttachLoginButton($container);
  } else {
    setTimeout(attachLoginButton, 1e3);
  }
}
function didAttachLoginButton($container) {
  const btn = document.createElement("button");
  btn.textContent = "点击登录插件";
  $container.appendChild(btn);
  btn.className = "border p-3 rounded-md";
  let isLogging = false;
  btn.addEventListener("click", async () => {
    if (isLogging) {
      return;
    }
    isLogging = true;
    btn.textContent = "登录中...";
    await delay(1e3);
    try {
      await checkAndSetupToken();
      btn.textContent = "登录成功, 即将关闭页面";
      await delay(2e3);
      chrome.runtime.sendMessage({ action: "close_current_tab", data: {} });
    } catch (ex) {
      if (ex.message) {
        btn.textContent = ex.message;
      }
    } finally {
      isLogging = false;
    }
  });
  btn.click();
}
async function checkAndSetupToken() {
  const res = await chrome.runtime.sendMessage({
    action: "is_logged_in",
    data: {}
  });
  if (!res.success) {
    throw new Error("获取登录状态失败, 请重试");
  }
  const isLoggedIn = res.data.isLoggedIn;
  if (!isLoggedIn) {
    await setToken();
  }
}
async function setToken() {
  const token = window.localStorage.getItem("auth-token");
  if (!token) {
    setTimeout(() => setToken(), 1e3);
  } else {
    const res = await chrome.runtime.sendMessage({
      action: "set_token",
      data: {
        token
      }
    });
    if (!res.success) {
      throw new Error("登录失败，请重试");
    }
  }
}
function delay(time) {
  return new Promise((resolve) => {
    setTimeout(() => resolve(""), time);
  });
}
main();
